/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.model;

import com.aptana.ruby.debug.core.model.IRubyStackFrame;
import com.aptana.ruby.debug.core.model.IRubyValue;
import com.aptana.ruby.debug.core.model.IRubyVariable;
import com.aptana.ruby.internal.debug.core.RubyDebuggerProxy;
import com.aptana.ruby.internal.debug.core.model.RubyDebugElement;
import com.aptana.ruby.internal.debug.core.model.RubyDebugTarget;
import com.aptana.ruby.internal.debug.core.model.RubyProcessingException;
import com.aptana.ruby.internal.debug.core.model.RubyValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class RubyVariable
extends RubyDebugElement
implements IRubyVariable {
    private boolean isStatic;
    private boolean isLocal;
    private boolean isInstance;
    private boolean isConstant;
    private IRubyStackFrame stackFrame;
    private String name;
    private String objectId;
    private IValue value;
    private IRubyVariable parent;
    private boolean valueHasChanged = false;

    public RubyVariable(IRubyStackFrame stackFrame, String name, String scope) {
        super(stackFrame.getDebugTarget());
        this.initialize(stackFrame, name, scope, null, new RubyValue(this));
    }

    public RubyVariable(IRubyStackFrame stackFrame, String name, String scope, String value, String type, boolean hasChildren, String objectId) {
        super(stackFrame.getDebugTarget());
        this.initialize(stackFrame, name, scope, objectId, new RubyValue(this, value, type, hasChildren));
    }

    protected final void initialize(IRubyStackFrame stackFrame, String name, String scope, String objectId, RubyValue value) {
        this.stackFrame = stackFrame;
        this.value = value;
        this.name = name;
        this.objectId = objectId;
        this.isStatic = scope.equals("class");
        this.isLocal = scope.equals("local");
        this.isInstance = scope.equals("instance");
        this.isConstant = scope.equals("constant");
    }

    public IValue getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getValue().getReferenceTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.valueHasChanged;
    }

    public void setValue(String expression) throws DebugException {
        try {
            String assignee = this.getName();
            if (this.isHashValue()) {
                assignee = String.valueOf(this.parent.getName()) + "[" + assignee + "]";
            } else if (this.isArrayValue()) {
                assignee = String.valueOf(this.parent.getName()) + assignee;
            }
            RubyVariable var = this.getRubyDebuggerProxy().readInspectExpression(this.stackFrame, String.valueOf(assignee) + " = " + expression);
            this.value = var.getValue();
            this.valueHasChanged = true;
            this.fireChangeEvent(512);
        }
        catch (RubyProcessingException e) {
            throw new DebugException((IStatus)new Status(4, "com.aptana.ruby.debug.core", -1, e.getMessage(), (Throwable)e));
        }
    }

    public RubyDebuggerProxy getRubyDebuggerProxy() {
        return ((RubyDebugTarget)this.getDebugTarget()).getRubyDebuggerProxy();
    }

    public void setValue(IValue value) throws DebugException {
        if (value instanceof RubyValue) {
            RubyValue val = (RubyValue)value;
            RubyVariable var = val.getOwner();
            this.setValue(var.getName());
        } else {
            this.setValue(value.getValueString());
        }
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public String toString() {
        if (this.isHashValue()) {
            return String.valueOf(this.getName()) + " => " + this.getValue();
        }
        return String.valueOf(this.getName()) + " = " + this.getValue();
    }

    @Override
    public IRubyStackFrame getStackFrame() {
        return this.stackFrame;
    }

    @Override
    public IRubyVariable getParent() {
        return this.parent;
    }

    public void setParent(IRubyVariable parent) {
        this.parent = parent;
    }

    @Override
    public String getQualifiedName() {
        if (this.parent == null) {
            return this.getName();
        }
        if (this.isHashValue()) {
            if (((RubyValue)this.getValue()).getReferenceTypeName().equals("String")) {
                return String.valueOf(this.parent.getQualifiedName()) + "[" + this.getName() + "]";
            }
            return "[ObjectSpace._id2ref(" + this.getObjectId() + ")]";
        }
        if (this.getName().startsWith("[")) {
            return String.valueOf(this.parent.getQualifiedName()) + this.getName();
        }
        return String.valueOf(this.parent.getQualifiedName()) + "." + this.getName();
    }

    @Override
    public boolean isInstance() {
        return this.isInstance;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isConstant() {
        return this.isConstant;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public boolean isHashValue() {
        if (this.parent == null) {
            return false;
        }
        try {
            String type = ((IRubyValue)this.parent.getValue()).getReferenceTypeName();
            return type.equals("Hash") || type.equals("HashWithIndifferentAccess") || type.equals("ActionController::Flash::FlashHash");
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    private boolean isArrayValue() {
        if (this.parent == null) {
            return false;
        }
        try {
            String type = ((IRubyValue)this.parent.getValue()).getReferenceTypeName();
            return type.equals("Array");
        }
        catch (DebugException debugException) {
            return false;
        }
    }
}

